## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
set.seed(420)
p <- rnorm(100, 20, 5)
q <- rnorm(100, 20, 5)
DKL <- KL_div(p, q, -Inf, Inf)

## ----echo = FALSE-------------------------------------------------------------
plot(density(p),
  col = "blue",
  main = "",
  xlab = "",
  ylab = ""
)
lines(density(q), col = "red")
legend(
  "topleft",
  legend = paste("DKL: ", trunc(DKL * 10^4) / 10^4),
)

## -----------------------------------------------------------------------------
data("gauss_example_1", package = "YEAB", envir = environment())
data("gauss_example_2", package = "YEAB", envir = environment())
P <- gauss_example_1
Q <- gauss_example_2

DKL_real <- KL_div(P$Response_Average, Q$Response_Average, -Inf, Inf)
print(DKL_real)

## ----echo = FALSE-------------------------------------------------------------
plot(P$Response_Average[1:90],
  type = "l", col = "blue",
  main = "",
  ylim = c(0, max(Q$Response_Average)),
  xlab = "Time",
  ylab = "Response Average"
)
lines(Q$Response_Average[1:90], type = "l", col = "red")
legend(
  "topright",
  legend = paste("DKL_real: ", trunc(DKL_real * 10^4) / 10^4)
)

