/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.extractors;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsResiduals;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.EasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.IMovingHolidayVariable;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.IUserVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import lombok.Generated;

public final class LinearModelExtractors {
    @Generated
    private LinearModelExtractors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Default
    extends InformationMapping<GeneralLinearModel> {
        public static final int IMEAN = 0;
        public static final int ITD = 10;
        public static final int ILP = 11;
        public static final int IEASTER = 12;
        public static final int AO = 20;
        public static final int LS = 21;
        public static final int TC = 22;
        public static final int SO = 23;
        public static final int IOUTLIER = 29;
        public static final int IIV = 30;
        public static final int IRAMP = 40;
        public static final int IOTHER = 50;

        private String regressionItem(String key) {
            return Dictionary.concatenate((String[])new String[]{"regression", key});
        }

        private String advancedItem(String key) {
            return Dictionary.concatenate((String[])new String[]{"regression.details", key});
        }

        private String mlItem(String key) {
            return Dictionary.concatenate((String[])new String[]{"regression.ml", key});
        }

        public Default() {
            this.set("y", TsData.class, source -> source.getDescription().getSeries());
            this.set("period", Integer.class, source -> source.getDescription().getSeries().getAnnualFrequency());
            this.set("span.start", TsPeriod.class, source -> source.getDescription().getSeries().getStart());
            this.set("span.end", TsPeriod.class, source -> source.getDescription().getSeries().getDomain().getLastPeriod());
            this.set("span.n", Integer.class, source -> source.getDescription().getSeries().length());
            this.set("span.missing", Integer.class, source -> source.getEstimation().getMissing().length);
            this.set("log", Integer.class, source -> source.getDescription().isLogTransformation() ? 1 : 0);
            this.set("adjust", String.class, source -> source.getDescription().getLengthOfPeriodTransformation().name());
            this.set(this.regressionItem("espan.start"), TsPeriod.class, source -> source.getEstimation().getDomain().getStartPeriod());
            this.set(this.regressionItem("espan.end"), TsPeriod.class, source -> source.getEstimation().getDomain().getLastPeriod());
            this.set(this.regressionItem("espan.n"), Integer.class, source -> source.getEstimation().getDomain().length());
            this.set(this.regressionItem("espan.missing"), Integer.class, source -> source.getEstimation().getMissing().length);
            this.set(this.regressionItem("mean"), Integer.class, source -> source.isMeanCorrection() ? 1 : 0);
            this.set(this.regressionItem("nlp"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof ILengthOfPeriodVariable));
            this.set(this.regressionItem("ntd"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof ITradingDaysVariable));
            this.set(this.regressionItem("nmh"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof IMovingHolidayVariable));
            this.set(this.regressionItem("nout"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof IOutlier));
            this.set(this.regressionItem("nao"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof AdditiveOutlier));
            this.set(this.regressionItem("nls"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof LevelShift));
            this.set(this.regressionItem("ntc"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof TransitoryChange));
            this.set(this.regressionItem("nso"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof PeriodicOutlier));
            this.set(this.regressionItem("nusers"), Integer.class, source -> this.count((GeneralLinearModel)source, var -> var instanceof IUserVariable));
            this.set(this.regressionItem("leaster"), Integer.class, source -> {
                Variable[] variables = source.getDescription().getVariables();
                Optional<Variable> found = Arrays.stream(variables).filter(var -> var.getCore() instanceof EasterVariable).findAny();
                if (found.isPresent()) {
                    EasterVariable ev = (EasterVariable)found.orElseThrow().getCore();
                    return ev.getDuration();
                }
                return 0;
            });
            this.set(this.regressionItem("description"), String[].class, source -> {
                TsDomain domain = source.getDescription().getSeries().getDomain();
                Variable[] vars = source.getDescription().getVariables();
                if (vars.length == 0) {
                    return null;
                }
                int n = Arrays.stream(vars).mapToInt(var -> var.dim()).sum();
                String[] nvars = new String[n];
                int j = 0;
                for (int i = 0; i < vars.length; ++i) {
                    int m = vars[i].dim();
                    if (m == 1) {
                        nvars[j++] = vars[i].getCore().description((TimeSeriesDomain)domain);
                        continue;
                    }
                    for (int k = 0; k < m; ++k) {
                        nvars[j++] = vars[i].getCore().description(k, (TimeSeriesDomain)domain);
                    }
                }
                return nvars;
            });
            this.set(this.regressionItem("type"), int[].class, source -> {
                Variable[] vars = source.getDescription().getVariables();
                if (vars.length == 0) {
                    return null;
                }
                int n = Arrays.stream(vars).mapToInt(var -> var.dim()).sum();
                int[] tvars = new int[n];
                int j = 0;
                for (int i = 0; i < vars.length; ++i) {
                    int m = vars[i].dim();
                    int type = this.type(vars[i].getCore());
                    for (int k = 0; k < m; ++k) {
                        tvars[j++] = type;
                    }
                }
                return tvars;
            });
            this.set(this.advancedItem("coefficients"), double[].class, source -> source.getEstimation().getCoefficients().toArray());
            this.set(this.advancedItem("covar"), Matrix.class, source -> source.getEstimation().getCoefficientsCovariance());
            this.set(this.advancedItem("covar-ml"), Matrix.class, source -> this.mul(source.getEstimation().getCoefficientsCovariance(), this.mlcorrection(source.getEstimation().getStatistics())));
            this.set(this.mlItem("parameters"), double[].class, source -> source.getEstimation().getParameters().getValues().toArray());
            this.set(this.mlItem("pcovar"), Matrix.class, source -> source.getEstimation().getParameters().getCovariance());
            this.set(this.mlItem("pcovar-ml"), Matrix.class, source -> this.mul(source.getEstimation().getParameters().getCovariance(), this.mlcorrection(source.getEstimation().getStatistics())));
            this.set(this.mlItem("pscore"), double[].class, source -> source.getEstimation().getParameters().getScores().toArray());
            this.delegate("likelihood", LikelihoodStatistics.class, source -> source.getEstimation().getStatistics());
            this.delegate("residuals", TsResiduals.class, source -> source.getResiduals());
        }

        private double mlcorrection(LikelihoodStatistics ll) {
            double n = ll.getEffectiveObservationsCount();
            return (n - (double)ll.getEstimatedParametersCount()) / n;
        }

        private Matrix mul(Matrix m, double c) {
            double[] cm = m.toArray();
            int i = 0;
            while (i < cm.length) {
                int n = i++;
                cm[n] = cm[n] * c;
            }
            return Matrix.of((double[])cm, (int)m.getRowsCount(), (int)m.getColumnsCount());
        }

        private int type(ITsVariable var) {
            if (var instanceof TrendConstant) {
                return 0;
            }
            if (var instanceof ITradingDaysVariable) {
                return 10;
            }
            if (var instanceof ILengthOfPeriodVariable) {
                return 11;
            }
            if (var instanceof IEasterVariable) {
                return 12;
            }
            if (var instanceof IOutlier) {
                IOutlier iOutlier = (IOutlier)var;
                return switch (iOutlier.getCode()) {
                    case "AO" -> 20;
                    case "LS" -> 21;
                    case "TC" -> 22;
                    case "SO", "PO" -> 23;
                    default -> 29;
                };
            }
            if (var instanceof InterventionVariable) {
                return 30;
            }
            if (var instanceof Ramp) {
                return 40;
            }
            return 50;
        }

        public Class getSourceClass() {
            return GeneralLinearModel.class;
        }

        public int getPriority() {
            return 1;
        }

        private int countVar(GeneralLinearModel source, Predicate<Variable> pred) {
            Variable[] variables = source.getDescription().getVariables();
            int n = 0;
            for (int i = 0; i < variables.length; ++i) {
                if (!pred.test(variables[i])) continue;
                n += variables[i].dim();
            }
            return n;
        }

        private int count(GeneralLinearModel source, Predicate<ITsVariable> pred) {
            Variable[] variables = source.getDescription().getVariables();
            int n = 0;
            for (int i = 0; i < variables.length; ++i) {
                ITsVariable core = variables[i].getCore();
                if (!pred.test(core)) continue;
                n += core.dim();
            }
            return n;
        }
    }
}

