## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(foqat)
head(voc)

## -----------------------------------------------------------------------------
voc_con=vocct(voc, unit = "ppbv")
summary(voc_con)

## -----------------------------------------------------------------------------
voc_con[["MW_Result"]]

## -----------------------------------------------------------------------------
head(voc_con[["Con_ugm"]])

## -----------------------------------------------------------------------------
voc_con[["Con_ugm_stat"]]

## -----------------------------------------------------------------------------
head(voc_con[["Con_ugm_group"]])

## -----------------------------------------------------------------------------
voc_con[["Con_ugm_group_stat"]]

## -----------------------------------------------------------------------------
head(voc_con[["Con_ppbv"]])

## -----------------------------------------------------------------------------
voc_con[["Con_ppbv_stat"]]

## -----------------------------------------------------------------------------
head(voc_con[["Con_ppbv_group"]])

## -----------------------------------------------------------------------------
voc_con[["Con_ppbv_group_stat"]]

## -----------------------------------------------------------------------------
voc_ofp=ofp(voc)
summary(voc_ofp)

## -----------------------------------------------------------------------------
voc_ofp[["MIR_Result"]]

## -----------------------------------------------------------------------------
head(voc_ofp[["OFP_Result"]])

## -----------------------------------------------------------------------------
voc_ofp[["OFP_Result_stat"]]

## -----------------------------------------------------------------------------
head(voc_ofp[["OFP_Result_group"]])

## -----------------------------------------------------------------------------
voc_ofp[["OFP_Result_group_stat"]]

## -----------------------------------------------------------------------------
voc_loh=loh(voc)
summary(voc_loh)

## -----------------------------------------------------------------------------
voc_loh[["KOH_Result"]]

## -----------------------------------------------------------------------------
head(voc_loh[["LOH_Result"]])

## -----------------------------------------------------------------------------
voc_loh[["LOH_Result_stat"]]

## -----------------------------------------------------------------------------
head(voc_loh[["LOH_Result_group"]])

## -----------------------------------------------------------------------------
voc_loh[["LOH_Result_group_stat"]]

## ----eval = FALSE-------------------------------------------------------------
#  koh("propene")
#  #> [1] "propene 26.4360E-12 cm3/molecule-sec (25 deg C) [AopWin v1.92]"

