/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.util.iterators.IntEnumeration;
import choco.kernel.memory.structure.IndexedObject;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;

public class LightState
implements IndexedObject {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected int idx;
    protected int layerIdx;
    protected Hashtable htransitions;
    protected Arcs[] trPred;

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setLayerIdx(int idx) {
        this.layerIdx = idx;
    }

    public int getLayerIdx() {
        return this.layerIdx;
    }

    @Override
    public int getObjectIdx() {
        return this.layerIdx;
    }

    public void init(LightState ls) {
        this.htransitions = ls.htransitions;
        this.trPred = ls.trPred;
        this.idx = ls.idx;
        this.layerIdx = ls.layerIdx;
    }

    public Enumeration<? extends Arcs> getEnumerationPred() {
        return new Enumerator();
    }

    public Enumeration<? extends Integer> getEnumerationSucc() {
        return this.htransitions.keys();
    }

    public LightState delta(int value) {
        return (LightState)this.htransitions.get(value);
    }

    public boolean hasDelta(int value) {
        return this.htransitions.get(value) != null;
    }

    public class Arcs {
        protected LightState st;
        protected int[] values;

        public Arcs(LightState st, BitSet values) {
            this.st = st;
            this.values = new int[values.cardinality()];
            int cTab = 0;
            int i = values.nextSetBit(0);
            while (i >= 0) {
                this.values[cTab] = i;
                ++cTab;
                i = values.nextSetBit(i + 1);
            }
        }

        public LightState getSt() {
            return this.st;
        }

        public int getValue(int idx) {
            return this.values[idx];
        }

        public IntEnumeration getEnumerationPred() {
            return new ValEnumerator();
        }

        private class ValEnumerator
        implements IntEnumeration {
            int currentIdx = 0;
            int maxSize;

            public ValEnumerator() {
                this.maxSize = Arcs.this.values.length;
            }

            @Override
            public boolean hasMoreElements() {
                return this.currentIdx < this.maxSize;
            }

            @Override
            public int nextElement() {
                return Arcs.this.values[this.currentIdx++];
            }
        }
    }

    private class Enumerator<Arc>
    implements Enumeration<Arc> {
        int currentIdx = 0;
        int maxSize;

        Enumerator() {
            this.maxSize = LightState.this.trPred.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currentIdx < this.maxSize;
        }

        @Override
        public Arc nextElement() {
            return (Arc)LightState.this.trPred[this.currentIdx++];
        }
    }
}

