/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class WienerNumbersDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"WPATH", "WPOL"};
    double[][] matr = null;
    DoubleArrayResult wienerNumbers = null;
    ConnectionMatrix connectionMatrix = new ConnectionMatrix();
    AtomContainerManipulator atm = new AtomContainerManipulator();

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#wienerNumbers", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtomContainer atomContainer) {
        int[][] distances;
        this.wienerNumbers = new DoubleArrayResult(2);
        double wienerPathNumber = 0.0;
        double wienerPolarityNumber = 0.0;
        this.matr = ConnectionMatrix.getMatrix((IAtomContainer)AtomContainerManipulator.removeHydrogens((IAtomContainer)atomContainer));
        for (int[] distance : distances = PathTools.computeFloydAPSP((double[][])this.matr)) {
            for (int j = 0; j < distances.length; ++j) {
                int partial = distance[j];
                wienerPathNumber += (double)partial;
                if (partial != 3) continue;
                wienerPolarityNumber += 1.0;
            }
        }
        this.wienerNumbers.add(wienerPathNumber /= 2.0);
        this.wienerNumbers.add(wienerPolarityNumber /= 2.0);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)this.wienerNumbers, this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(2);
    }

    public String[] getParameterNames() {
        return null;
    }

    public Object getParameterType(String name) {
        return null;
    }
}

