/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.matrices;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.advanced.matrices.MatrixOperations;

public final class MatrixOperationsLoader {

    public static final class Processor {
        private final Iterable<MatrixOperations.Processor> source = ServiceLoader.load(MatrixOperations.Processor.class);
        private final AtomicReference<MatrixOperations.Processor> resource = new AtomicReference<MatrixOperations.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private MatrixOperations.Processor doLoad() throws IllegalStateException {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseThrow(() -> new IllegalStateException("Missing mandatory provider of MatrixOperations.Processor"));
        }

        public MatrixOperations.Processor get() {
            return this.resource.get();
        }

        public void set(MatrixOperations.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() throws IllegalStateException {
            Iterable<MatrixOperations.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws IllegalStateException {
            Iterable<MatrixOperations.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

