/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.matrices;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

class LightMatrix
implements Matrix {
    private static final LightMatrix EMPTY = new LightMatrix(new double[0], 0, 0);
    private final double[] storage;
    private final int nrows;
    private final int ncolumns;

    public static LightMatrix empty() {
        return EMPTY;
    }

    LightMatrix(double[] storage, int nrows, int ncolumns) {
        this.storage = storage;
        this.nrows = nrows;
        this.ncolumns = ncolumns;
    }

    @Override
    public double[] toArray() {
        return (double[])this.storage.clone();
    }

    @Override
    public double get(int row, int column) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nrows || column < 0 || column >= this.ncolumns) {
            throw new IndexOutOfBoundsException();
        }
        return this.storage[row + column * this.nrows];
    }

    @Override
    public DoubleSeq row(int irow) {
        if (irow < 0 || irow >= this.nrows) {
            throw new IndexOutOfBoundsException();
        }
        return DoubleSeq.of(this.storage, irow, this.ncolumns, this.nrows);
    }

    @Override
    public DoubleSeq column(int icolumn) {
        if (icolumn < 0 || icolumn >= this.ncolumns) {
            throw new IndexOutOfBoundsException();
        }
        return DoubleSeq.of(this.storage, icolumn * this.nrows, this.nrows);
    }

    @Override
    public DoubleSeq subDiagonal(int pos) {
        int n;
        if (pos >= this.ncolumns) {
            return Doubles.EMPTY;
        }
        if (-pos >= this.nrows) {
            return Doubles.EMPTY;
        }
        int beg = 0;
        int inc = 1 + this.nrows;
        if (pos > 0) {
            beg = pos * this.nrows;
            n = Math.min(this.nrows, this.ncolumns - pos);
        } else if (pos < 0) {
            beg = -pos;
            n = Math.min(this.nrows + pos, this.ncolumns);
        } else {
            n = Math.min(this.nrows, this.ncolumns);
        }
        return DoubleSeq.of(this.storage, beg, n, inc);
    }

    @Override
    public DoubleSeq diagonal() {
        int inc = 1 + this.nrows;
        int n = Math.min(this.nrows, this.ncolumns);
        return DoubleSeq.of(this.storage, 0, n, inc);
    }

    @Override
    public int getColumnsCount() {
        return this.ncolumns;
    }

    @Override
    public int getRowsCount() {
        return this.nrows;
    }

    public String toString() {
        return Matrix.format(this);
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LightMatrix)) {
            return false;
        }
        LightMatrix other = (LightMatrix)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nrows != other.nrows) {
            return false;
        }
        if (this.ncolumns != other.ncolumns) {
            return false;
        }
        return Arrays.equals(this.storage, other.storage);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof LightMatrix;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.nrows;
        result = result * 59 + this.ncolumns;
        result = result * 59 + Arrays.hashCode(this.storage);
        return result;
    }
}

