/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.arima;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArimaForecasts;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.ssf.arima.SsfArima;
import jdplus.toolkit.base.core.ssf.ckms.CkmsFilter;
import jdplus.toolkit.base.core.ssf.univariate.PredictionErrorDecomposition;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;

public class ExactArimaForecasts
implements ArimaForecasts {
    private IArimaModel arima;
    private Ssf ssf;
    private BackFilter bar;
    private double mean;
    private boolean bmean;

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public boolean prepare(IArimaModel model, boolean bmean) {
        this.bmean = bmean;
        IArimaModel cmodel = model;
        if (bmean) {
            BackFilter ar = model.getStationaryAr();
            BackFilter ur = model.getNonStationaryAr();
            BackFilter ma = model.getMa();
            this.bar = ar.times(ur);
            double var = model.getInnovationVariance();
            BackFilter D = BackFilter.D1;
            cmodel = new ArimaModel(ar, ur.times(D), ma.times(D), var);
        } else {
            this.bar = model.getAr();
        }
        this.arima = cmodel;
        this.ssf = Ssf.of(SsfArima.stateComponent(cmodel), SsfArima.defaultLoading());
        return true;
    }

    private double[] fcasts(SsfData sd, int nf) {
        DataBlock a;
        CkmsFilter filter = new CkmsFilter(SsfArima.fastInitializer(this.arima));
        PredictionErrorDecomposition perr = new PredictionErrorDecomposition(false);
        filter.process(this.ssf, sd, perr);
        double[] f = new double[nf];
        if (nf >= this.ssf.getStateDim()) {
            a = filter.getFinalState().a();
            a.copyTo(f, 0);
            int last = a.length() - 1;
            for (int i = this.ssf.getStateDim(); i < nf; ++i) {
                this.ssf.dynamics().TX(0, a);
                f[i] = a.get(last);
            }
        } else {
            filter.getFinalState().a().range(0, nf).copyTo(f, 0);
        }
        if (this.bmean) {
            a = filter.getFinalState().a();
            DataBlock s = DataBlock.make(a.length() - this.bar.getDegree());
            this.bar.apply(a, s);
            this.mean = s.get(s.length() - 1);
        }
        return f;
    }

    @Override
    public DoubleSeq forecasts(DoubleSeq data, int nf) {
        SsfData sd = new SsfData(data);
        return DoubleSeq.of((double[])this.fcasts(sd, nf));
    }

    @Override
    public boolean prepare(IArimaModel model, double mean) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

