/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.random.JdkRNG;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.dk.BaseDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.dk.FastDkFilter;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class DiffuseSimulationSmoother {
    private static final Normal N = new Normal();
    private static final RandomNumberGenerator RNG = JdkRNG.newRandom(0L);
    private static final double EPS = 1.0E-8;
    private FastMatrix LA;
    private final ISsf ssf;
    private final ISsfData data;
    private final ISsfDynamics dynamics;
    private final ISsfLoading loading;
    private final ISsfError error;
    private final Smoothing smoothing;
    private final double var;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillRandoms(DataBlock u) {
        Normal normal = N;
        synchronized (normal) {
            for (int i = 0; i < u.length(); ++i) {
                u.set(i, N.random(RNG));
            }
        }
    }

    public DiffuseSimulationSmoother(ISsf ssf, ISsfData data, boolean rescaleVariance) {
        this.ssf = ssf;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.data = data;
        this.initSsf();
        this.smoothing = new Smoothing();
        this.var = rescaleVariance ? this.smoothing.frslts.var() : 1.0;
    }

    public Smoothing getReferenceSmoothing() {
        return this.smoothing;
    }

    public Simulation newSimulation() {
        return new Simulation();
    }

    private double lh(int pos) {
        return this.error == null ? 0.0 : Math.sqrt(this.error.at(pos));
    }

    private double h(int pos) {
        return this.error == null ? 0.0 : this.error.at(pos);
    }

    private void initSsf() {
        int dim = this.ssf.getStateDim();
        this.LA = FastMatrix.square(dim);
        this.ssf.initialization().Pf0(this.LA);
        SymmetricMatrix.lcholesky(this.LA, 1.0E-8);
    }

    private void generateTransitionRandoms(int pos, DataBlock u) {
        DiffuseSimulationSmoother.fillRandoms(u);
    }

    private void generateMeasurementRandoms(DataBlock e) {
        DiffuseSimulationSmoother.fillRandoms(e);
        e.mul(this.lh(0));
    }

    private void generateInitialState(DataBlock a) {
        DiffuseSimulationSmoother.fillRandoms(a);
        LowerTriangularMatrix.Lx(this.LA, a);
    }

    public class Smoothing
    extends BaseSimulation {
        Smoothing() {
            super(DkToolkit.sqrtFilter(DiffuseSimulationSmoother.this.ssf, DiffuseSimulationSmoother.this.data, false));
            this.smooth();
        }

        @Override
        protected double getError(int pos) {
            return this.frslts.error(pos);
        }
    }

    public class Simulation
    extends BaseSimulation {
        final DataBlockStorage states;
        private DataBlockStorage simulatedStates;
        private DataBlockStorage simulatedInnovations;
        final DataBlockStorage transitionInnovations;
        final double[] measurementErrors;
        private double[] ferrors;
        private final double[] simulatedData;

        public Simulation() {
            super(DiffuseSimulationSmoother.this.smoothing.frslts);
            this.states = new DataBlockStorage(this.dim, this.n);
            this.transitionInnovations = new DataBlockStorage(this.resdim, this.n);
            if (DiffuseSimulationSmoother.this.error != null) {
                this.measurementErrors = new double[this.n];
                DiffuseSimulationSmoother.this.generateMeasurementRandoms(DataBlock.copyOf(this.measurementErrors));
            } else {
                this.measurementErrors = null;
            }
            this.simulatedData = new double[this.n];
            this.generateData();
            this.filter();
            this.smooth();
        }

        private void generateData() {
            double std = Math.sqrt(DiffuseSimulationSmoother.this.var);
            DataBlock a0f = DataBlock.make(this.dim);
            DiffuseSimulationSmoother.this.generateInitialState(a0f);
            a0f.mul(std);
            DataBlock a = DataBlock.make(this.dim);
            DiffuseSimulationSmoother.this.ssf.initialization().a0(a);
            a.add(a0f);
            this.states.save(0, a);
            this.simulatedData[0] = DiffuseSimulationSmoother.this.loading.ZX(0, a);
            if (this.measurementErrors != null) {
                this.simulatedData[0] = this.simulatedData[0] + this.measurementErrors[0] * std;
            }
            DataBlock q = DataBlock.make(this.resdim);
            for (int i = 1; i < this.simulatedData.length; ++i) {
                DiffuseSimulationSmoother.this.dynamics.TX(i, a);
                if (DiffuseSimulationSmoother.this.dynamics.hasInnovations(i - 1)) {
                    DiffuseSimulationSmoother.this.generateTransitionRandoms(i - 1, q);
                    q.mul(std);
                    this.transitionInnovations.save(i - 1, q);
                    DiffuseSimulationSmoother.this.dynamics.addSU(i - 1, a, q);
                }
                this.states.save(i, a);
                this.simulatedData[i] = DiffuseSimulationSmoother.this.loading.ZX(i, a);
                if (this.measurementErrors == null) continue;
                int n = i;
                this.simulatedData[n] = this.simulatedData[n] + this.measurementErrors[i] * std;
            }
        }

        private void filter() {
            FastDkFilter f = new FastDkFilter(DiffuseSimulationSmoother.this.ssf, this.frslts, false);
            this.ferrors = (double[])this.simulatedData.clone();
            f.filter(DataBlock.copyOf(this.ferrors));
        }

        public double[] getSimulatedData() {
            return this.simulatedData;
        }

        public DataBlockStorage getGeneratedStates() {
            return this.states;
        }

        @Override
        protected double getError(int pos) {
            return this.ferrors[pos];
        }

        public DoubleSeq getErrors() {
            return DoubleSeq.of((double[])this.ferrors);
        }

        public DataBlockStorage getSimulatedStates() {
            if (this.simulatedStates == null) {
                this.computeSimulatedStates();
            }
            return this.simulatedStates;
        }

        private void computeSimulatedStates() {
            this.simulatedStates = new DataBlockStorage(this.dim, this.n);
            DataBlockStorage sm = DiffuseSimulationSmoother.this.smoothing.getSmoothedStates();
            DataBlockStorage ssm = this.getSmoothedStates();
            DataBlock a = DataBlock.make(this.dim);
            for (int i = 0; i < this.n; ++i) {
                a.copy(sm.block(i));
                a.sub(ssm.block(i));
                a.add(this.states.block(i));
                this.simulatedStates.save(i, a);
            }
        }

        public DataBlockStorage getSimulatedInnovations() {
            if (this.simulatedInnovations == null) {
                this.computeSimulatedInnovations();
            }
            return this.simulatedInnovations;
        }

        private void computeSimulatedInnovations() {
            this.simulatedInnovations = new DataBlockStorage(this.resdim, this.n);
            DataBlockStorage sm = DiffuseSimulationSmoother.this.smoothing.getSmoothedInnovations();
            DataBlockStorage ssm = this.getSmoothedInnovations();
            DataBlock u = DataBlock.make(this.dim);
            for (int i = 0; i < this.n; ++i) {
                u.copy(sm.block(i));
                u.sub(ssm.block(i));
                if (DiffuseSimulationSmoother.this.dynamics.hasInnovations(i)) {
                    u.add(this.transitionInnovations.block(i));
                }
                this.simulatedInnovations.save(i, u);
            }
        }
    }

    abstract class BaseSimulation {
        protected final BaseDiffuseFilteringResults frslts;
        protected final DataBlockStorage smoothedInnovations;
        protected final DataBlock esm;
        protected DataBlockStorage smoothedStates;
        protected DataBlock a0;
        protected final int dim;
        protected final int resdim;
        protected final int n;
        protected final int nd;
        protected DataBlock R;
        protected DataBlock Ri;

        protected abstract double getError(int var1);

        protected BaseSimulation(BaseDiffuseFilteringResults frslts) {
            this.frslts = frslts;
            this.dim = DiffuseSimulationSmoother.this.ssf.getStateDim();
            this.resdim = DiffuseSimulationSmoother.this.dynamics.getInnovationsDim();
            this.n = DiffuseSimulationSmoother.this.data.length();
            this.nd = frslts.getEndDiffusePosition();
            this.smoothedInnovations = new DataBlockStorage(this.resdim, this.n);
            this.esm = DiffuseSimulationSmoother.this.error != null ? DataBlock.make(this.n) : null;
        }

        protected final void smooth() {
            this.R = DataBlock.make(this.dim);
            this.Ri = DataBlock.make(this.dim);
            this.doNormalSmoothing();
            this.doDiffuseSmoohing();
            this.computeInitialState();
        }

        private void doNormalSmoothing() {
            DataBlock U = DataBlock.make(this.resdim);
            int pos = this.n;
            while (--pos >= this.nd) {
                if (DiffuseSimulationSmoother.this.dynamics.hasInnovations(pos)) {
                    DiffuseSimulationSmoother.this.dynamics.XS(pos, this.R, U);
                    this.smoothedInnovations.save(pos, U);
                }
                double e = this.getError(pos);
                double v = this.frslts.errorVariance(pos);
                boolean missing = !Double.isFinite(e);
                DiffuseSimulationSmoother.this.dynamics.XT(pos, this.R);
                if (!missing && e != 0.0) {
                    double c = (e - this.R.dot(this.frslts.M(pos))) / v;
                    DiffuseSimulationSmoother.this.loading.XpZd(pos, this.R, c);
                }
                if (this.esm == null) continue;
                if (!missing) {
                    this.esm.set(pos, DiffuseSimulationSmoother.this.h(pos));
                    continue;
                }
                this.esm.set(pos, Double.NaN);
            }
        }

        private void doDiffuseSmoohing() {
            DataBlock C = DataBlock.make(this.dim);
            DataBlock Ci = DataBlock.make(this.dim);
            DataBlock U = DataBlock.make(this.resdim);
            int pos = this.nd;
            while (--pos >= 0) {
                if (DiffuseSimulationSmoother.this.dynamics.hasInnovations(pos)) {
                    DiffuseSimulationSmoother.this.dynamics.XS(pos, this.R, U);
                    this.smoothedInnovations.save(pos, U);
                }
                double e = this.getError(pos);
                double f = this.frslts.errorVariance(pos);
                double fi = this.frslts.diffuseNorm2(pos);
                C.copy(this.frslts.M(pos));
                if (fi != 0.0) {
                    Ci.copy(this.frslts.Mi(pos));
                    Ci.mul(1.0 / fi);
                    C.addAY(-f, Ci);
                    C.mul(1.0 / fi);
                } else if (f != 0.0) {
                    C.mul(1.0 / f);
                    Ci.set(0.0);
                }
                boolean missing = !Double.isFinite(e);
                DiffuseSimulationSmoother.this.dynamics.XT(pos, this.R);
                DiffuseSimulationSmoother.this.dynamics.XT(pos, this.Ri);
                if (fi == 0.0) {
                    if (!missing && f != 0.0) {
                        c = e / f - this.R.dot(C);
                        DiffuseSimulationSmoother.this.loading.XpZd(pos, this.R, c);
                    }
                } else if (!missing && f != 0.0) {
                    c = -this.Ri.dot(Ci);
                    double ci = e / fi + c - this.R.dot(C);
                    DiffuseSimulationSmoother.this.loading.XpZd(pos, this.Ri, ci);
                    double cf = -this.R.dot(Ci);
                    DiffuseSimulationSmoother.this.loading.XpZd(pos, this.R, cf);
                }
                if (this.esm == null) continue;
                if (!missing) {
                    this.esm.set(pos, DiffuseSimulationSmoother.this.h(pos));
                    continue;
                }
                this.esm.set(pos, Double.NaN);
            }
        }

        private void computeInitialState() {
            this.a0 = DataBlock.make(this.dim);
            FastMatrix Pf0 = FastMatrix.square(this.dim);
            ISsfInitialization initializer = DiffuseSimulationSmoother.this.ssf.initialization();
            initializer.a0(this.a0);
            initializer.Pf0(Pf0);
            this.a0.addProduct(this.R, Pf0.columnsIterator());
            if (initializer.isDiffuse()) {
                FastMatrix Pi0 = FastMatrix.square(this.dim);
                initializer.Pi0(Pi0);
                this.a0.addProduct(this.Ri, Pi0.columnsIterator());
            }
        }

        public DataBlock getSmoothedInnovations(int pos) {
            return this.smoothedInnovations.block(pos);
        }

        public DataBlock getSmoothedState(int pos) {
            if (this.smoothedStates == null) {
                this.generatesmoothedStates();
            }
            return this.smoothedStates.block(pos);
        }

        public DataBlockStorage getSmoothedInnovations() {
            return this.smoothedInnovations;
        }

        public DataBlockStorage getSmoothedStates() {
            if (this.smoothedStates == null) {
                this.generatesmoothedStates();
            }
            return this.smoothedStates;
        }

        private void generatesmoothedStates() {
            this.smoothedStates = new DataBlockStorage(this.dim, this.n);
            this.smoothedStates.save(0, this.a0);
            int cur = 1;
            DataBlock a = DataBlock.of((DoubleSeq)this.a0);
            while (cur < this.n) {
                DiffuseSimulationSmoother.this.dynamics.TX(cur - 1, a);
                if (DiffuseSimulationSmoother.this.dynamics.hasInnovations(cur - 1)) {
                    DataBlock u = this.smoothedInnovations.block(cur - 1);
                    DiffuseSimulationSmoother.this.dynamics.addSU(cur - 1, a, u);
                }
                this.smoothedStates.save(cur++, a);
            }
        }
    }
}

