/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.utility;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixNorms;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.utility.Randoms;
import lombok.Generated;

public final class DynamicsCoherence {
    public static void check(ISsfDynamics dyn, int dim) {
        DynamicsCoherence.check(dyn, dim, 0, 1);
    }

    public static void check(ISsfDynamics dyn, int dim, int start, int end) {
        for (int j = start; j < end; ++j) {
            FastMatrix T2 = FastMatrix.square(dim);
            dyn.T(j, T2);
            FastMatrix M = Randoms.randomMatrix(dim);
            FastMatrix P = Randoms.randomSymmetricMatrix(dim);
            DataBlock v = Randoms.randomArray(dim);
            DataBlock w = v.deepClone();
            dyn.TX(j, w);
            DataBlock tx = DataBlock.make(dim);
            tx.product(T2.rowsIterator(), v);
            if (tx.distance((DoubleSeq)w) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            FastMatrix TM = GeneralMatrix.AB(T2, M);
            FastMatrix m = M.deepClone();
            dyn.TM(j, m);
            if (MatrixNorms.frobeniusNorm(TM.minus(m)) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            FastMatrix MT = GeneralMatrix.AB(M, T2);
            m = M.deepClone();
            dyn.MT(j, m);
            if (MatrixNorms.frobeniusNorm(MT.minus(m)) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            w = v.deepClone();
            dyn.XT(j, w);
            DataBlock xt = DataBlock.make(dim);
            xt.product(v, T2.columnsIterator());
            if (xt.distance((DoubleSeq)w) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            FastMatrix TVT = GeneralMatrix.ABt(GeneralMatrix.AB(T2, P), T2);
            FastMatrix p = P.deepClone();
            dyn.TVT(j, p);
            if (MatrixNorms.frobeniusNorm(TVT.minus(p)) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            if (!dyn.hasInnovations(j)) continue;
            FastMatrix V = FastMatrix.square(dim);
            dyn.V(j, V);
            FastMatrix S = FastMatrix.make(dim, dyn.getInnovationsDim());
            dyn.S(j, S);
            if (!(MatrixNorms.frobeniusNorm(V.minus(SymmetricMatrix.XXt(S))) > 1.0E-9)) continue;
            throw new SsfException("Invalid model definition");
        }
    }

    @Generated
    private DynamicsCoherence() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

