## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
options(rmarkdown.html_vignette.check_title = FALSE)
library("vfunc")
set.seed(1)

## ----out.width='20%', out.extra='style="float:right; padding:10px"',echo=FALSE----
knitr::include_graphics(system.file("help/figures/vfunc.png", package = "vfunc"))

## ----error=TRUE---------------------------------------------------------------
try({
f <- function(x){x^2}
g <- function(x){1/(1-x)}
f + g
})

## ----vfuncfplusg--------------------------------------------------------------
library("vfunc")
f <- as.vf(f)
g <- as.vf(g)
(f + g)(1:10)

## ----showfplusginvfunc--------------------------------------------------------
(f + 4*g - f*g)(1:10)

## -----------------------------------------------------------------------------
f <- function(x,y,z){x + x*y - x/z}
g <- function(x,y,z){x^2 - z}

## ----standardway--------------------------------------------------------------
 x <- 1.2
 y <- 1.7
 z <- 4.3		
(f(x,y,z) + g(x,y,z))*(f(x,y,z) + 4 - 2*f(x,y,z)*g(x,y,z))

## ----usevfunc-----------------------------------------------------------------
f <- as.vf(f)
g <- as.vf(g)
((f + g)*(f + 4 - 2*f*g))(x,y,z)

## ----compexample--------------------------------------------------------------
f(x + z, y + z, f(x, x, y) - g(x, x, y)) + g(x + z, y + z, f(x, x, y) - g(x, x, y))

## ----fgxzyz-------------------------------------------------------------------
(f + g)(x + z, y + z, (f - g)(x, x, y))

## ----sprayexamp---------------------------------------------------------------
library("onion")
options("show_onions_compactly" = TRUE)
f <- as.vf(function(x,y){x + x*y})
g <- as.vf(function(x,y){x^2 + y})
(f + g - f*g)(1 + Hj,Hk)

## ----showsin------------------------------------------------------------------
vfunc::Sin

## ----combinetriganduser-------------------------------------------------------
fun <- as.vf(function(x){x^2 + 2})
(fun(Sin) + Sin(fun) - 3*Sin*fun)(0.32)

## ----seeeval------------------------------------------------------------------
fun(sin(0.32)) + sin(fun(0.32)) - 3*sin(0.32)*fun(0.32)

## ----defcomposite-------------------------------------------------------------
j <- as.vf(function(x,y){Cos(x) + Sin(x-y)})
k <- as.vf(function(x,y){Tan(x) + Log(x+y)})
l <- as.vf(function(x,y){Sin(x/2) + x^2   })

## ----looktwo1-----------------------------------------------------------------
(j + k + l)(Sin + Log, Cos + Exp)(Sin + Tan)(0.4)

## ----looktwo2-----------------------------------------------------------------
j(sin(sin(0.4) + tan(0.4)) + log(sin(0.4) + tan(0.4)), cos(sin(0.4) + tan(0.4)) +
exp(sin(0.4) + tan(0.4))) + k(sin(sin(0.4) + tan(0.4)) + log(sin(0.4) + tan(0.4)),
cos(sin(0.4) + tan(0.4)) + exp(sin(0.4) + tan(0.4)))+ l(sin(sin(0.4) + tan(0.4)) +
log(sin(0.4) + tan(0.4)), cos(sin(0.4) + tan(0.4)) + exp(sin(0.4) + tan(0.4)))

## ----looktwo3-----------------------------------------------------------------
A <- function(x,y){j(x,y) + k(x,y) + l(x,y)}
B <- function(x){sin(x) + log(x)}
C <- function(x){cos(x) + exp(x)}
D <- function(x){sin(x) + tan(x)}
x <- 0.4
A(B(D(x)), C(D(x)))

