/*
 * Decompiled with CFR 0.152.
 */
package org.af.jhlir.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.af.jhlir.call.RIllegalNameException;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RLegalName {
    private final String name;
    public static final String[] reserved = new String[]{"if", "else", "repeat", "while", "function", "for", "in", "next", "break", "TRUE", "FALSE", "NULL", "Inf", "NaN", "NA", "NA_integer_", "NA_real_", "NA_complex_", "NA_character_"};

    public RLegalName(String name) throws RIllegalNameException {
        if (RLegalName.isPassedArg(name)) {
            throw new RIllegalNameException(name + " is a reserved R expression. You are not allowed to use '...' or '..' followed by a number!");
        }
        if (RLegalName.isReserved(name)) {
            throw new RIllegalNameException(name + " is a reserved R word! ");
        }
        if (!RLegalName.isLegal(name)) {
            throw new RIllegalNameException(name + " is an illegal R name. A valid name consists of letters, numbers and the" + "  dot or underline characters and starts with a letter or the dot" + "  not followed by a number.");
        }
        this.name = name;
    }

    public static RLegalName makeRLegalNameUnchecked(String name) {
        try {
            return new RLegalName(name);
        }
        catch (RIllegalNameException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static List<RLegalName> makeRLegalNamesUnchecked(List<String> names) {
        ArrayList<RLegalName> result = new ArrayList<RLegalName>();
        for (String s : names) {
            result.add(RLegalName.makeRLegalNameUnchecked(s));
        }
        return result;
    }

    public static List<RLegalName> makeRLegalNamesUnchecked(String[] names) {
        return RLegalName.makeRLegalNamesUnchecked(Arrays.asList(names));
    }

    public String getName() {
        return this.name;
    }

    public static boolean isLegal(String name) {
        Pattern pattern = Pattern.compile("([a-zA-Z]|\\.[a-zA-Z])[\\w\\.]*");
        return !RLegalName.isReserved(name) && pattern.matcher(name).matches();
    }

    public static boolean isReserved(String name) {
        return ArrayUtils.contains((Object[])reserved, (Object)name) || RLegalName.isPassedArg(name);
    }

    public static boolean isPassedArg(String name) {
        Pattern pattern = Pattern.compile("\\.\\.[\\d+|\\.]");
        return pattern.matcher(name).matches();
    }

    public String toString() {
        return this.name;
    }
}

