# DEplotting

Repository maintained by **Jannis Burkhard** (<bildungsbericht-daten@dipf.de>)

**DEplotting** is an R package for downloading and processing geospatial data to visualize German regional data (states/Länder: `LAN`, districts/Kreis[-freie Städte]: `KRS`, municipalities/Gemeinden: `GEM`). It simplifies working with shapefiles provided by the German Federal Agency for Cartography and Geodesy (BKG), enabling the creation of maps and tables across administrative regions.

---

## 1. `download_geo()` – Download Geodata

**Purpose:** Automatically downloads and unzips shapefiles from the official BKG portal (1998–2022) into a user-specific directory (using `tools::R_user_dir("DEplotting", "data")`).

### Features
- Creates the target directory if missing.
- Skips years already present.
- Handles special cases for 2013–2014 URL formats.
- Retries failed downloads up to 3 times.
- Unzips data, removes ZIPs, and logs status/errors.

### Usage
```r
download_geo()
download_geo(start_year = 2000, end_year = 2010)
```

---

## 2. `list_codes()` – Interactive Table of Merged Geodata

**Purpose:** Can be used to look up regional codes of administrative areas for a specified year by returning an interactive HTML table with administrative metadata.

### Features
- Selects the correct attribute (`SHN`, `AGS`, or `AGS_0`) based on year.
- Dynamically builds paths for historical changes in naming/structure.
- Filters and deduplicates records based on year-specific rules.
- Merges municipality → district → state using derived keys (`AGS_Kreis`, `AGS_Land`).
- Uses `DT::datatable` for interactive preview.

### Usage
```r
list_codes(year = 2022)
```

---

## 3. `map_plot()` – Visualize Regional Data on a Map

**Purpose:** Creates choropleth maps of German administrative areas (states, districts, or municipalities) using user-provided data.

### Features

- Validates your dataset's variable.
- Accepts AGS codes or state abbreviations.
- Loads shapefiles using dynamic year-based path logic.
- Merges user data with geodata (by `ARS` or `AGS`) at various levels.
- Provides a color palette used by the German national report on education.
- Optional numeric labeling on the map.
- Uses `patchwork` to combine plots when multiple regions are specified.

### Arguments
- `data`: A data frame containing the numeric variable to be visualized. Must include a column for region codes (`AGS` or `ARS`) and optionally a `Year` or `Jahr` column.
- `var`: Character. The name of the variable (column) in `data` to visualize.
- `map_section`: Character vector of AGS codes or shortcuts (e.g., `"DE"` for Germany, `"BE"` for Berlin). Defines the outer area of the map. See `list_codes()` for valid codes.  
  You can also see the full list of state abbreviations here:  
  [See Appendix A: German State Abbreviations](#appendix-a-german-state-abbreviations)
- `level`: One of `"land"`, `"kreis"`, or `"gemeinde"`. Determines the resolution of the map (states, districts, or municipalities).
- `add_labels`: Logical. If `TRUE`, shows the actual variable values (numbers) on the map.
- `year`: Integer. Filters the data for this year (must be present in a `Year` or `Jahr` column).
- `geo_year`: Integer or `""`. Specifies which year's geospatial data to use. If `""`, defaults to the value of `year`.
- `palette`: Character. Provides color palette used by the German national report on education. Options: `"Red"`, `"Blue"`, `"Green"`, `"Yellow"`, `"Orange"`, `"Pink"`, `"Teal"`, `"Purple"`.

### Usage
```r
map_plot(
  data = yourdata,
  var = "yourtargetvariable",
  map_section = "DE",  # or state codes like "BB", "BE"
  level = "land",
  add_labels = FALSE,
  year = 2022,
  geo_year = "",
  palette = "red"
)
```

### Example usage with built-in dataset

In addition to loading external CSV files, the map_plot() function can also be used with a dataset included in the package. The following example demonstrates how to visualize the number of students using the built-in nstudents2022 dataset. This is especially useful for quick testing or demonstrations without needing to prepare your own data files. The example plots student counts by state for all of Germany in 2022, using a red color palette.

```r
# Load the built-in dataset
data(nstudents2022, package = "DEplotting")

# Generate the map
map_plot(
  data = nstudents2022,
  var = "nStudents",
  map_section = "DE",  # DE stands for the whole Germany
  level = "land",
  add_labels = FALSE,
  year = 2022,
  geo_year = "",
  palette = "red"
)
```

---

## 4. `load_geodata()` – Load and Assigns Shapefiles to the R Environment

**Purpose:** Assigns Shapefiles to the R environment so that they can be used with other plotting packages.

### Features
- Selects the appropriate attribute by year.
- Constructs paths using `system.file()` for portable use.
- Reads shapefiles via `sf::st_read()`.
- Filters and transforms data using year-specific logic.
- Assigns processed data to: `vg250_lan`, `vg250_krs`, `vg250_gem`.

### Usage
```r
load_geodata(year = 2015)

# Objects available in the global environment:
vg250_lan  # States/Länder
vg250_krs  # Districts/Kreis(-freie Städte)
vg250_gem  # Municipalities/Gemeinden
```

---

## 📌 Maintenance Note

This package is based on BKG geodata from 1998 to 2022. If new shapefiles become available (e.g., for 2023 or beyond), updates may be required for:
- Path definitions in `get_shapefile_path()`
- Naming conventions for LAN/KRS/GEM layers

## Appendix A: German State Abbreviations

| State Name                 | Abbreviation |
|---------------------------|--------------|
| Baden-Württemberg         | `BW`         |
| Bavaria                   | `BY`         |
| Berlin                    | `BE`         |
| Brandenburg               | `BB`         |
| Bremen                    | `HB`         |
| Hamburg                   | `HH`         |
| Hesse                     | `HE`         |
| Lower Saxony              | `NI`         |
| Mecklenburg-Vorpommern    | `MV`         |
| North Rhine-Westphalia    | `NW`         |
| Rhineland-Palatinate      | `RP`         |
| Saarland                  | `SL`         |
| Saxony                    | `SN`         |
| Saxony-Anhalt             | `ST`         |
| Schleswig-Holstein        | `SH`         |
| Thuringia                 | `TH`         |
| Entire Germany            | `DE`         |
