## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(envsetup)

# Create temporary directory for demonstration
dir <- fs::file_temp()
dir.create(dir)
config_path <- file.path(dir, "_envsetup.yml")

# Write a basic config file
file_conn <- file(config_path)
writeLines(
"default:
  paths:
    data: '/demo/DEV/username/project1/data'
    output: '/demo/DEV/username/project1/output'
    programs: '/demo/DEV/username/project1/programs'", file_conn)
close(file_conn)

## -----------------------------------------------------------------------------
# Load the configuration
envsetup_config <- config::get(file = config_path)

# Apply the configuration to your R session
rprofile(envsetup_config)

## ----echo = TRUE--------------------------------------------------------------
# See all available path objects
ls(envsetup_environment)

# Access individual paths
get_path(data)
get_path(output)
get_path(programs)

## ----echo = FALSE-------------------------------------------------------------
# Clean up
unlink(dir, recursive=TRUE)

