
<!-- README.md is generated from README.Rmd. Please edit that file -->

# `glsm()`

<!-- badges: start -->

[![R-CMD-check](https://github.com/jlvia1191/glsm/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/jlvia1191/glsm/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

# Welcome to the *glsm* package!

When the response variable Y takes one of R \> 1 values, the function
‘glsm()’ computes the maximum likelihood estimates (MLEs) of the
parameters under four models: null, complete, saturated, and logistic.
It also calculates the log-likelihood values for each model. This method
assumes independent, non-identically distributed variables. For grouped
data with a multinomial outcome, where observations are divided into J
populations, the function ‘glsm()’ provides estimation for any number K
of explanatory variables.

## Details

The saturated model is characterized by the assumptions 1 and 2
presented in section 2.3 by Llinás (2006).

## Installation

You can install the development version of glsm like so:

``` r
# install.packages("devtools")

remotes::install_github("jlvia1191/glsm", force = TRUE)

devtools::install_github("jlvia1191/glsm", force = TRUE)

```

## Example Usage

This is a basic example which shows you how to solve a common problem:

``` r
library(glsm)
data("hsbdemo", package = "glsm")
model <- glsm(prog ~ ses + gender, data = hsbdemo, ref = "academic")
model
#> 
#> Call:
#> glsm(formula = prog ~ ses + gender, data = hsbdemo, ref = "academic")
#> 
#> Populations in Saturated Model: 6
#> 
#> Coefficients: 
#>                         Coef(B) Std.Error
#> (Intercept):general  -1.6547758 0.4175354
#> (Intercept):vocation -1.8469099 0.4478055
#> seslow:general        1.4118732 0.5064763
#> seslow:vocation       1.3534875 0.5548849
#> sesmiddle:general     0.7550865 0.4561360
#> sesmiddle:vocation    1.4430949 0.4709456
#> gendermale:general    0.2216624 0.3716764
#> gendermale:vocation   0.1098969 0.3599743
#>                         Exp(B)
#> (Intercept):general  0.1911349
#> (Intercept):vocation 0.1577238
#> seslow:general       4.1036349
#> seslow:vocation      3.8709018
#> sesmiddle:general    2.1277956
#> sesmiddle:vocation   4.2337787
#> gendermale:general   1.2481500
#> gendermale:vocation  1.1161630
#> 
#> Log Likelihood: 
#>          Estimation
#> Complete     0.0000
#> Null      -204.0967
#> Logit     -195.5208
#> Saturate  -194.5159
```

## References

\[1\] Hosmer, D., Lemeshow, S., & Sturdivant, R. (2013). *Applied
Logistic Regression* (3rd ed.). New York: Wiley. ISBN: 978-0-470-58247-3

\[2\] Llinás, H. (2006). Precisiones en la teoría de los modelos
logísticos. *Revista Colombiana de Estadística*, 29(2), 239–265.

\[3\] Llinás, H., & Carreño, C. (2012). The Multinomial Logistic Model
for the Case in Which the Response Variable Can Assume One of Three
Levels and Related Models. *Revista Colombiana de Estadística*, 35(1),
131–138.

\[4\] Orozco, E., Llinás, H., & Fonseca, J. (2020). Convergence theorems
in multinomial saturated and logistic models. *Revista Colombiana de
Estadística*, 43(2), 211–231.

\[5\] Llinás, H., Arteta, M., & Tilano, J. (2016). El modelo de
regresión logística para el caso en que la variable de respuesta puede
asumir uno de tres niveles: estimaciones, pruebas de hipótesis y
selección de modelos. *Revista de Matemática: Teoría y Aplicaciones*,
23(1), 173–197.

## Author(s)

Jorge Luis Villalba Acevedo \[cre, aut\], Universidad Tecnológica de
Bolívar, Cartagena-Colombia.\\ Humberto Llinas Solano \[aut\],
Universidad del Norte, Barranquilla-Colombia \\ Jorge Borja \[aut\],
Universidad del Norte, Barranquilla-Colombia \\ Jorge Tilano \[aut\],
Universidad del Norte, Barranquilla-Colombia.

------------------------------------------------------------------------

If you found any ERRORS or have SUGGESTIONS, please report them to my
email. Thanks.
