## jointseg

This package implements functions to quickly segment multivariate signals into piecewise-constant profiles, as well as a framework to generate realistic copy-number profiles. A typical application is the joint segmentation of total DNA copy numbers and allelic ratios obtained from Single Nucleotide Polymorphism (SNP) microarrays in cancer studies.

## Installation

You can install jointseg from github with:

    # install.packages("devtools")
    devtools::install_github("mpierrejean/jointseg")

## Usage

The main high-level joint segmentation functions are:
* `jointSeg` for arbitrary signals, see `?jointSeg`.
* `PSSeg` for bivariate copy-number signals, see `?PSSeg` and `vignette("PSSeg")`.

We also refer to  `vignette("dataGeneration")` for a description of the generation of synthetic DNA copy-number profiles using data from the `acnr` package.

## References

Pierre-Jean, M, Rigaill, G. J. and Neuvial, P. (2015). "Performance Evaluation of DNA Copy Number Segmentation Methods." *Briefings in Bioinformatics*, no. 4: 600–615.


## Software status

| Resource:     | GitHub        | Travis CI      | Appveyor         |
| ------------- | ------------------- | -------------- | ---------------- |
| _Platforms:_  | _Multiple_          | _Linux & OS X_ | _Windows_        |
| R CMD check  | | [![Travis Build Status](https://travis-ci.org/mpierrejean/jointseg.svg?branch=master)](https://app.travis-ci.com/mpierrejean/jointseg) | [![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/github/mpierrejean/jointseg?branch=master&svg=true)](https://ci.appveyor.com/project/mpierrejean/jointseg) |
| Test coverage | | <a href="https://app.codecov.io/gh/mpierrejean/jointseg"><img src="https://codecov.io/gh/mpierrejean/jointseg/branch/master/graph/badge.svg" alt="Coverage Status"/></a> | |
