/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries.util;

import internal.toolkit.base.api.timeseries.util.ByObjObsList;
import internal.toolkit.base.api.timeseries.util.NoOpDataBuilder;
import internal.toolkit.base.api.timeseries.util.ObsList;
import internal.toolkit.base.api.timeseries.util.TsDataBuilderUtil;
import java.time.LocalDateTime;
import java.util.function.Function;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.util.ObsCharacteristics;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.api.timeseries.util.TsDataBuilder;
import lombok.Generated;

public final class ByObjDataBuilder<T>
implements TsDataBuilder<T> {
    private final ByObjObsList<T> obsList;
    private final boolean skipMissingValues;
    private final Function<ObsList, TsData> maker;

    public static TsDataBuilder<LocalDateTime> fromDateTime(ObsGathering gathering, ObsCharacteristics[] characteristics) {
        return TsDataBuilderUtil.isValid(gathering) ? new ByObjDataBuilder<LocalDateTime>(ByObjDataBuilder.getDateTimeObsList(TsDataBuilderUtil.isOrdered(characteristics)), !gathering.isIncludeMissingValues(), TsDataBuilderUtil.getMaker(gathering)) : new NoOpDataBuilder(TsDataBuilderUtil.INVALID_AGGREGATION);
    }

    @Override
    public TsDataBuilder clear() {
        this.obsList.clear();
        return this;
    }

    @Override
    public TsDataBuilder add(T date, Number value) {
        if (date != null) {
            if (value != null) {
                this.obsList.add(date, value.doubleValue());
            } else if (!this.skipMissingValues) {
                this.obsList.add(date, Double.NaN);
            }
        }
        return this;
    }

    @Override
    public TsData build() {
        return this.maker.apply(this.obsList);
    }

    private static ByObjObsList<LocalDateTime> getDateTimeObsList(boolean preSorted) {
        return preSorted ? new ByObjObsList.PreSorted<LocalDateTime>(ByObjDataBuilder::getPeriodIdFunc, 32) : new ByObjObsList.Sortable<LocalDateTime>(ByObjDataBuilder::getPeriodIdFunc, LocalDateTime::compareTo);
    }

    private static int getPeriodIdFunc(TsUnit unit, LocalDateTime reference, LocalDateTime date) {
        return (int)TsPeriod.idAt(reference, unit, date);
    }

    @Generated
    private ByObjDataBuilder(ByObjObsList<T> obsList, boolean skipMissingValues, Function<ObsList, TsData> maker) {
        this.obsList = obsList;
        this.skipMissingValues = skipMissingValues;
        this.maker = maker;
    }
}

