/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.Clock;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.HasLog;
import jdplus.toolkit.base.api.processing.ProcDocument;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.processing.ProcessingStatus;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;

public interface MultiTsDocument<S extends ProcSpecification, R extends Explorable>
extends ProcDocument<S, List<Ts>, R> {
    @Override
    public List<Ts> getInput();

    @Override
    public void set(S var1, List<Ts> var2);

    @Override
    public void set(List<Ts> var1);

    public void setAll(S var1, List<Ts> var2, R var3);

    @Override
    public R getResult();

    default public ProcessingLog getLog() {
        if (this.getStatus() != ProcessingStatus.Valid || !(this.getResult() instanceof HasLog)) {
            return ProcessingLog.dummy();
        }
        return ((HasLog)this.getResult()).getLog();
    }

    default public boolean isTsFrozen() {
        Object ts = this.getInput();
        if (ts.isEmpty()) {
            return false;
        }
        Iterator iterator = ts.iterator();
        while (iterator.hasNext()) {
            Ts s = (Ts)iterator.next();
            if (!s.isFrozen()) continue;
            return true;
        }
        return false;
    }

    default public void freezeTs() {
        Object ts = this.getInput();
        if (ts.isEmpty()) {
            return;
        }
        boolean changed = false;
        ArrayList<Ts> nts = new ArrayList<Ts>();
        Iterator iterator = ts.iterator();
        while (iterator.hasNext()) {
            Ts s = (Ts)iterator.next();
            if (!s.isFrozen()) {
                nts.add(s.freeze());
                changed = true;
                continue;
            }
            nts.add(s);
        }
        if (changed) {
            this.set((List<Ts>)nts);
        }
    }

    default public void unfreezeTs() {
        Object ts = this.getInput();
        if (ts.isEmpty()) {
            return;
        }
        boolean changed = false;
        ArrayList<Ts> nts = new ArrayList<Ts>();
        Iterator iterator = ts.iterator();
        while (iterator.hasNext()) {
            Ts s = (Ts)iterator.next();
            if (s.isFrozen()) {
                nts.add(s.unfreeze(TsFactory.getDefault(), TsInformationType.Data));
                changed = true;
                continue;
            }
            nts.add(s);
        }
        if (changed) {
            this.set((List<Ts>)nts);
            this.getMetadata().put("@timestamp", LocalDate.now(Clock.systemDefaultZone()).format(DateTimeFormatter.ISO_DATE));
        }
    }
}

