/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.linearfilters;

import internal.toolkit.base.core.math.linearfilters.EigenValuesDecomposer;
import internal.toolkit.base.core.math.linearfilters.EigenValuesDecomposer2;
import internal.toolkit.base.core.math.linearfilters.FastEigenValuesDecomposer;
import internal.toolkit.base.core.math.linearfilters.RobustSymmetricFrequencyResponseDecomposer;
import internal.toolkit.base.core.math.linearfilters.SymmetricFrequencyResponseDecomposer;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class SymmetricFilterAlgorithms {
    private static final int ROBUST_LIMIT = 5;

    public static SymmetricFilter.Decomposer decomposer(LinearSystemSolver solver) {
        return (filter, Q) -> {
            int nc;
            if (Q.length() == 1) {
                double[] data = filter.coefficientsAsPolynomial().toArray();
                data[0] = data[0] / 2.0;
                double q0 = Math.abs(Q.get(0));
                if (q0 != 1.0) {
                    int i = 0;
                    while (i < data.length) {
                        int n = i++;
                        data[n] = data[n] / q0;
                    }
                }
                return BackFilter.ofInternal(data);
            }
            Polynomial q = Q.asPolynomial();
            Polynomial c = filter.coefficientsAsPolynomial();
            int nq = q.degree();
            int r = nq > (nc = c.degree()) ? nq : nc;
            FastMatrix a = FastMatrix.square(r + 1);
            double[] mc = new double[r + 1];
            for (int i = 0; i <= r; ++i) {
                mc[r - i] = i <= nc ? c.get(i) : 0.0;
                for (int j = 0; j <= i; ++j) {
                    if (i - j <= nq) {
                        double a1 = q.get(i - j);
                        a.add(i, j, a1);
                    }
                    if (r - i + j > nq) continue;
                    double a2 = q.get(r - i + j);
                    a.add(i, r - j, a2);
                }
            }
            DataBlock g = DataBlock.of(mc);
            if (solver == null) {
                LinearSystemSolver.robustSolver().solve(a, g);
            } else {
                solver.solve(a, g);
            }
            return BackFilter.ofInternal(g.reverse().toArray());
        };
    }

    public static SymmetricFilter.Factorizer fastFactorizer() {
        return filter -> {
            SymmetricFrequencyResponseDecomposer decomposer = new SymmetricFrequencyResponseDecomposer();
            if (!decomposer.decompose(filter)) {
                return null;
            }
            return new SymmetricFilter.Factorization(decomposer.getBFilter(), decomposer.getFactor());
        };
    }

    public static SymmetricFilter.Factorizer robustFactorizer() {
        return filter -> {
            RobustSymmetricFrequencyResponseDecomposer decomposer = new RobustSymmetricFrequencyResponseDecomposer();
            if (!decomposer.decompose(filter)) {
                return null;
            }
            return new SymmetricFilter.Factorization(decomposer.getBFilter(), decomposer.getFactor());
        };
    }

    public static SymmetricFilter.Factorizer evFactorizer() {
        return filter -> {
            EigenValuesDecomposer decomposer = new EigenValuesDecomposer();
            if (!decomposer.decompose(filter)) {
                return null;
            }
            return new SymmetricFilter.Factorization(decomposer.getBFilter(), decomposer.getFactor());
        };
    }

    public static SymmetricFilter.Factorizer fastEvFactorizer() {
        return filter -> {
            FastEigenValuesDecomposer decomposer = new FastEigenValuesDecomposer();
            if (!decomposer.decompose(filter)) {
                return null;
            }
            return new SymmetricFilter.Factorization(decomposer.getBFilter(), decomposer.getFactor());
        };
    }

    public static SymmetricFilter.Factorizer evFactorizer2() {
        return filter -> {
            EigenValuesDecomposer2 decomposer = new EigenValuesDecomposer2();
            if (!decomposer.decompose(filter)) {
                return null;
            }
            return new SymmetricFilter.Factorization(decomposer.getBFilter(), decomposer.getFactor());
        };
    }

    public static SymmetricFilter.Factorizer factorizer() {
        return filter -> {
            SymmetricFilter.Factorization fac = SymmetricFilterAlgorithms.evFactorizer2().factorize(filter);
            if (fac == null && (fac = SymmetricFilterAlgorithms.evFactorizer().factorize(filter)) == null && (fac = SymmetricFilterAlgorithms.fastFactorizer().factorize(filter)) == null) {
                fac = SymmetricFilterAlgorithms.robustFactorizer().factorize(filter);
            }
            return fac;
        };
    }
}

