/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.normalizer;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.normalizer.DataNormalizer;

public class DecimalNormalizer
implements DataNormalizer {
    private static final double D_MAX = 10.0;
    private static final double D_MIN = 0.1;
    private final double dmax_;
    private final double dmin_;

    public DecimalNormalizer() {
        this.dmin_ = 0.1;
        this.dmax_ = 10.0;
    }

    public DecimalNormalizer(double dmin, double dmax) {
        this.dmin_ = dmin;
        this.dmax_ = dmax;
    }

    public double getMax() {
        return this.dmax_;
    }

    public double getMin() {
        return this.dmin_;
    }

    @Override
    public double normalize(DataBlock data) {
        double ymax;
        int n = data.length();
        int i = data.indexOf(x -> Double.isFinite(x));
        if (i == n) {
            return 1.0;
        }
        double ymin = ymax = data.get(i++);
        while (i < n) {
            double ycur = Math.abs(data.get(i));
            if (Double.isFinite(ycur)) {
                if ((ycur = Math.abs(ycur)) < ymin) {
                    ymin = ycur;
                } else if (ycur > ymax) {
                    ymax = ycur;
                }
            }
            ++i;
        }
        int k = 0;
        if (ymax < this.dmax_ && ymin > this.dmin_) {
            return 1.0;
        }
        while (ymin > 10.0) {
            --k;
            ymin /= 10.0;
        }
        while (ymax < 0.1) {
            ++k;
            ymax *= 10.0;
        }
        if (k != 0) {
            double f = 1.0;
            for (i = 0; i < k; ++i) {
                f *= 10.0;
            }
            for (i = k; i < 0; ++i) {
                f /= 10.0;
            }
            double c = f;
            data.apply(x -> x * c);
            return c;
        }
        return 1.0;
    }
}

