/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.PeriodicOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class SOFactory
implements RegressionVariableFactory<PeriodicOutlier> {
    static SOFactory FACTORY = new SOFactory();

    private SOFactory() {
    }

    @Override
    public boolean fill(PeriodicOutlier var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int period = var.getPeriod();
        if (period == 0) {
            period = start.getUnit().getAnnualFrequency();
        }
        PeriodicOutlierFactory fac = new PeriodicOutlierFactory(period, var.isZeroEnded());
        TsPeriod p = start.withDate(var.getPosition());
        int opos = start.until(p);
        fac.fill(opos, buffer.column(0));
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(PeriodicOutlier var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

