/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.attributeclassobservers;

import com.github.javacliparser.StringUtils;
import moa.AbstractMOAObject;

public class SingleVector
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected float[] array;

    public SingleVector() {
        this.array = new float[0];
    }

    public SingleVector(float[] toCopy) {
        this.array = new float[toCopy.length];
        System.arraycopy(toCopy, 0, this.array, 0, toCopy.length);
    }

    public SingleVector(SingleVector toCopy) {
        this(toCopy.getArrayRef());
    }

    public SingleVector(double[] arrayRef) {
        this.array = new float[arrayRef.length];
        for (int i = 0; i < arrayRef.length; ++i) {
            this.array[i] = (float)arrayRef[i];
        }
    }

    public int numValues() {
        return this.array.length;
    }

    public void setValue(int i, float v) {
        if (i >= this.array.length) {
            this.setArrayLength(i + 1);
        }
        this.array[i] = v;
    }

    public void addToValue(int i, float v) {
        if (i >= this.array.length) {
            this.setArrayLength(i + 1);
        }
        int n = i;
        this.array[n] = this.array[n] + v;
    }

    public void addValues(SingleVector toAdd) {
        this.addValues(toAdd.getArrayRef());
    }

    public void addValues(float[] toAdd) {
        if (toAdd.length > this.array.length) {
            this.setArrayLength(toAdd.length);
        }
        for (int i = 0; i < toAdd.length; ++i) {
            int n = i;
            this.array[n] = this.array[n] + toAdd[i];
        }
    }

    public void subtractValues(SingleVector toSubtract) {
        this.subtractValues(toSubtract.getArrayRef());
    }

    public void subtractValues(float[] toSubtract) {
        if (toSubtract.length > this.array.length) {
            this.setArrayLength(toSubtract.length);
        }
        for (int i = 0; i < toSubtract.length; ++i) {
            int n = i;
            this.array[n] = this.array[n] - toSubtract[i];
        }
    }

    public void addToValues(float toAdd) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = this.array[i] + toAdd;
        }
    }

    public void scaleValues(float multiplier) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = this.array[i] * multiplier;
        }
    }

    public float getValue(int i) {
        return i >= 0 && i < this.array.length ? this.array[i] : 0.0f;
    }

    public float sumOfValues() {
        float sum = 0.0f;
        for (float element : this.array) {
            sum += element;
        }
        return sum;
    }

    public int maxIndex() {
        int max = -1;
        for (int i = 0; i < this.array.length; ++i) {
            if (max >= 0 && !(this.array[i] > this.array[max])) continue;
            max = i;
        }
        return max;
    }

    public void normalize() {
        this.scaleValues(1.0f / this.sumOfValues());
    }

    public int numNonZeroEntries() {
        int count = 0;
        for (float element : this.array) {
            if ((double)element == 0.0) continue;
            ++count;
        }
        return count;
    }

    public float minWeight() {
        if (this.array.length > 0) {
            float min = this.array[0];
            for (int i = 1; i < this.array.length; ++i) {
                if (!(this.array[i] < min)) continue;
                min = this.array[i];
            }
            return min;
        }
        return 0.0f;
    }

    public float[] getArrayCopy() {
        float[] aCopy = new float[this.array.length];
        System.arraycopy(this.array, 0, aCopy, 0, this.array.length);
        return aCopy;
    }

    public float[] getArrayRef() {
        return this.array;
    }

    protected void setArrayLength(int l) {
        float[] newArray = new float[l];
        int numToCopy = this.array.length;
        if (numToCopy > l) {
            numToCopy = l;
        }
        System.arraycopy(this.array, 0, newArray, 0, numToCopy);
        this.array = newArray;
    }

    public void getSingleLineDescription(StringBuilder out) {
        this.getSingleLineDescription(out, this.numValues());
    }

    public void getSingleLineDescription(StringBuilder out, int numValues) {
        out.append("{");
        for (int i = 0; i < numValues; ++i) {
            if (i > 0) {
                out.append("|");
            }
            out.append(StringUtils.doubleToString(this.getValue(i), 3));
        }
        out.append("}");
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        this.getSingleLineDescription(sb);
    }
}

